// Brest le 29/06/98
// Author : BOUDENAN D.  EMAIL: daniel.boudenan@bsf.alcatel.fr
// Component Catgorie : Non Visible Component
// Component function  : Make DIR *.* > fic.txt or gives directories and files
//                       in a specific directory if MakeDir = False
// -----------------------------------------------------------------------------
// How used this component ?
// 1 - MakeDir    = True -> You can write DIR *.* > fic.txt
// 2 - NbrFic     = 0    -> You Have a problem or nothing found.
// 3 - NomFicDir  = name and extension of fic.txt
// 4 - RepToScan  = Where you want used the command DIR
// 5 - RepToWrite = If MakeDir=True, Where you want write the DIR
// Procedures:
// 1 - EcrireListeFichier  Input   Ouput
//                          None    None
//     But: Execute Dir in the specified directory
// 2 - LireListeFichier
//     Input : Index:Integer     --> N of Index where you want information
//     Ouput : FFileName:String  --> Name of File or directory
//             FTaille:String    --> Size of File or directory
//             FAge:String       --> Age of File or directory
//             FType:Boolean     --> True this is a directory
//                                   False this is a File
// -----------------------------------------------------------------------------
unit DBBox;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, FileCtrl;

type
  TDBBox = class(Tcomponent)

  private
    { Dclarations prives }
    FRepToScan  : String;  // Example : C:\AP\*.*
    FRepToWrite : String;  // Example : C:\Ap\SAUV\
    FNomFicDir  : String;  // Example : DIR.TXT
    FVersion    : String;
    FAuteur     : String;
    FNbrFic     : Integer;
    FMakeDir    : Boolean; // Valide l'criture du DIR.TXT

  protected
    { Dclarations protges }
    procedure SetRepToScan(Value : String);
    procedure SetRepToWrite(Value : String);
    procedure SetNomFicDir(Value : String);
    procedure SetMakeDir(Value : Boolean);

  public
   {Dclarations publiques }
    constructor Create(AOwner : TComponent);override;
    destructor  Destroy; override;
    procedure   EcrireListeFichier;
    procedure   LireListeFichier(Index     : Integer;
                             Var FFileName : String;
                             Var FTaille   : String;
                             Var FAge      : String;
                             Var FType     : Boolean);

   //procedure LireListeFichier;

  published
   { Dclarations publies }

   property RepToScan  : String  read FRepToScan  write SetRepToScan;
   property RepToWrite : String  read FRepToWrite write SetRepToWrite;
   property NomFicDir  : String  read FNomFicDir  write SetNomFicDir;
   property MakeDir    : Boolean read FMakeDIR    write SetMakeDIR;
   property Version    : String  read FVersion    write FVersion;
   property Auteur     : String  read FAuteur     write FAuteur;
   property NbrFic     : Integer read FNbrFic     write FNbrFic;
  end;

Const
 MAXTAB = 2048;

Type
 TTab   = Array[1..MAXTAB, 1..4] of String;

Var
 ListeFichier : TTab;

procedure Register;

implementation


procedure Register;
begin
  RegisterComponents('Win 3.1', [TDBBox]);
end;

Constructor TDBBox.Create(AOwner:TComponent);
Begin
 inherited Create(AOwner);
 FVersion   := '1.00';
 FAuteur    := 'daniel.boudenan@bsf.alcatel.fr';
 FNbrFic    := 0;
 RepToScan  := 'C:\*.*';
 RepToWrite := 'C:\';
 NomFicDir  := 'DIR.TXT';
End;

destructor TDBBox.Destroy;
begin
 inherited Destroy;
end;

procedure TDBBox.SetRepToScan(Value : String);
Begin
 FRepToScan := UpperCase(value);
End;

procedure TDBBox.SetRepToWrite(Value : String);
Begin
 FRepToWrite := UpperCase(value);
End;

procedure TDBBox.SetNomFicDir(Value : String);
Begin
 FNomFicDir := value;
End;

procedure TDBBox.SetMakeDir(Value : Boolean);
Begin
 FMakeDir := value;
End;

procedure TDBBox.EcrireListeFichier;
Const
 CAR_BLANC     = Chr(32);
Var
 i, j          : Integer;
 SearchRec     : TSearchRec;
 Ligne         : String;
 Flag          : Integer;
 Fic           : TextFile;
 CompteRep     : Integer;
 CompteFic     : Integer;
 SizeOfFic     : Integer;
 FileSys       : array[0..12] of Char;
 DiskLabel     : array[0..12] of Char;
 Serial        : DWord;
 DirLen        : DWord;
 SystemFlags   : DWord;

Begin
 // Initialisation
 CompteFic := 0;
 CompteRep := 0;
 SizeOfFic := 0;
 NbrFic    := 0;
 For i:= 1 To MAXTAB Do
  For j:= 1 To 4 Do
   ListeFichier[i,j] := '';
 // Recherche des rpertoires et des fichiers
 Flag := FindFirst(FRepToScan,faAnyFile,SearchRec);
 i         := 0;
 While (i < MAXTAB) And (Flag = 0) Do
  Begin
    Flag := FindNext(SearchRec);
    If Flag <> 0 Then
                  Begin
                   FindClose(SearchRec);
                   FNbrFic := i;
                  End
                 Else
                  Begin
                   If (SearchRec.Name <> '.') And (SearchRec.Name <> '..') Then
                     Begin
                      i                 := i + 1;
                      ListeFichier[i,1] := SearchRec.Name;
                      ListeFichier[i,2] := IntToStr(SearchRec.Size);
                      // FileDateToDateTime : Convertion d'un Integer en TDateTime
                      ListeFichier[i,3] := DateToStr(FileDateToDateTime(SearchRec.Time));
                      //                                          Archive ReadOnly Hide Compress
                      // SearchRec.Attr =  16 --> Rpertoire  16             +1     +2
                      // SearchRec.Attr = 128 --> Fichier    128    32       +1     +2    2048
                      ListeFichier[i,4] := IntToStr(SearchRec.Attr);
                      FNbrFic           := i;
                      // Showmessage('Nom = '+ ListeFichier[i,1]+ ' : ' + ListeFichier[i,2] + ' : '+ListeFichier[i,3] + ' : '+ListeFichier[i,4]);
                     End;
                  End; // Fin Si
  End; // Fin Tant Que
// Cration du fichier DIR.TXT
If (FMakeDir = True) Then
  Begin
   If DirectoryExists(FRepToWrite) Then
     Begin
      {$I-}
      GetVolumeInformation(PChar(Copy(FRepToScan,1,1)+':\'),@DiskLabel,12,@Serial,
                           DirLen,SystemFlags,@FileSys,12);
      AssignFile(Fic,FRepToWrite + FNomFicDir);
      Rewrite(Fic);
      Ligne := ' Le Volume dans le lecteur ' + FRepToScan[1] + ' s''appelle ' + DiskLabel;
      Writeln(Fic,Ligne);
      Ligne := ' le numro de srie du volume est '+ Copy(IntToHex(Serial,8),1,4) + '-' + Copy(IntToHex(Serial,8),5,4);
      Writeln(Fic,Ligne);
      Ligne := '';
      Writeln(Fic,Ligne);
      Ligne := ' Rpertoire de ' + Copy(FRepToScan,1,Length(FRepToScan) - 4);
      Writeln(Fic,Ligne);
      Ligne := '';
      Writeln(Fic,Ligne);
      For i := 1 To FNbrFic Do
       Begin
        Ligne := '';
        If (StrToInt(ListeFichier[i,4]) >= 16) And (StrToInt(ListeFichier[i,4]) < 32) Then
          Begin // C'est un rpertoire
           CompteRep := CompteRep + 1;
           //               Date[8c]+[2b]+Heure[5c]+[9b]+<DIR>[5c]+[10b]+Nom
           Ligne := Ligne + ListeFichier[i,3] + '                ' + '<DIR>'  + '          ';
          End
         Else
          Begin // C'est un fichier
           SizeOfFic := SizeOfFic + StrToInt(ListeFichier[i,2]);
           CompteFic := CompteFic + 1;
           //               Date[8c]+[2b]+Heure[5c]+[9b]+<DIR>[5c]+Size[9]+[1b]+Nom
           Ligne := Ligne + ListeFichier[i,3] + '                     ';
           For j := 1  To (9 - length(ListeFichier[i,2])) Do Ligne := Ligne + CAR_BLANC;
           Ligne := Ligne + ListeFichier[i,2] + CAR_BLANC;
          End;
        Ligne := Ligne + ListeFichier[i,1];
        Writeln(Fic,Ligne);
       End; // Fin For i = 1  FNbrFic
      Ligne := '';
      For j := 1  To (16 - Length(IntToStr(CompteFic))) Do Ligne := Ligne + CAR_BLANC;
      Ligne := Ligne + IntToStr(CompteFic)+ ' Fichier(s)';
      For j := 1  To (17 - Length(IntToStr(SizeOfFic))) Do Ligne := Ligne + CAR_BLANC;
      Ligne := Ligne + IntToStr(SizeOfFic) + ' octets';
      Writeln(Fic,Ligne);
      Ligne := '';
      For j := 1  To (16 - Length(IntToStr(CompteRep))) Do Ligne := Ligne + CAR_BLANC;
      Ligne := Ligne + IntToStr(CompteRep)+ ' Rpertoire(s)';
      For j := 1  To (14 - Length(IntToStr(DiskFree(Ord(FRepToScan[1])- 64)))) Do Ligne := Ligne + CAR_BLANC;
      Ligne := Ligne + IntToStr(DiskFree(Ord(FRepToScan[1])- 64)) + ' octets libres';
      Writeln(Fic,Ligne);
      Close(Fic);
      {$I+}
     End
    Else
     Begin
      Showmessage('DBBOX: '+ 'Rpertoire de Dpot du Fichier ' + FNomFicDir + ' introuvable!');
     End; // Fin Si Le rpertoire FRepToWrite Existe
  End; // Fin Si MakeDir = Vrai --> Cration d'un fichier Dir dans DIR.TXT
End; // Fin Procdure TDBBox.EcrireListeFichier;

procedure TDBBox.LireListeFichier(Index          : Integer;
                                   Var FFileName : String;
                                   Var FTaille   : String;
                                   Var FAge      : String;
                                   Var FType     : Boolean);

Begin
 FFileName := ListeFichier[Index,1];
 FTaille   := ListeFichier[Index,2];
 FAge      := ListeFichier[Index,3];
 If (StrToInt(ListeFichier[Index,4]) >= 16) And
    (StrToInt(ListeFichier[Index,4]) < 32) Then FType := True
                                           Else FType := False;
End;

//----------------------------------------------------------------------------//
end.
